import { createSlice, createAsyncThunk } from "@reduxjs/toolkit";

import { BASE_API_URL_STG } from "@env";
import { queryResponse } from "../util/processResponse.js";
const initialState = {
    banner: [],
    loading: true,
};
let URL = `${BASE_API_URL_STG}/sliders`;

export const getHomeBanner = createAsyncThunk(
    "banner/getHomeBanner",
    async () => {
        const response = await queryResponse(URL, "GET");
        return response;
    }
);

const homeBannerSlice = createSlice({
    name: "banner",
    initialState,
    extraReducers: (builder) => {
        builder.addCase(getHomeBanner.pending, (state) => {
            state.loading = true;
        });
        builder.addCase(getHomeBanner.fulfilled, (state, { payload = {} }) => {
            const { status, records } = payload || {};
            if (status?.code == 200) {
                state.banner = records?.data[0]?.slide;
            }
            state.loading = false;
        });
        builder.addCase(getHomeBanner.rejected, (state) => {
            state.loading = false;
        });
    },
});

export default homeBannerSlice.reducer;
